#include "CvGameCoreDLL.h"
#include "CvInfos.h"

//
// Python interface for info classes (formerly structs)
// These are simple enough to be exposed directly - no wrappers
//

void CyInfoPythonInterface1()
{
	OutputDebugString("Python Extension Module - CyInfoPythonInterface1\n");

	python::class_<CvInfoBase>("CvInfoBase")

		.def("isGraphicalOnly", &CvInfoBase::isGraphicalOnly, "bool ()")

		.def("getType", &CvInfoBase::getType, "string ()")
		.def("getButton", &CvInfoBase::getButton, "string ()")

		.def("getTextKey", &CvInfoBase::pyGetTextKey, "wstring ()")
		.def("getText", &CvInfoBase::pyGetText, "wstring ()")
		.def("getDescription", &CvInfoBase::pyGetDescription, "wstring ()")
		.def("getDescriptionForm", &CvInfoBase::pyGetDescriptionForm, "wstring ()")
		.def("getCivilopedia", &CvInfoBase::pyGetCivilopedia, "wstring ()")
		.def("getStrategy", &CvInfoBase::pyGetStrategy, "wstring ()")
		.def("getHelp", &CvInfoBase::pyGetHelp, "wstring ()")
		.def("isMatchForLink", &CvInfoBase::isMatchForLink, "bool (string)")

		;

	python::class_<CvScalableInfo>("CvScalableInfo")
		.def("setScale", &CvScalableInfo::setScale, "void (float fScale)")
		.def("getScale", &CvScalableInfo::getScale, "float  ()")
		;

	python::class_<CvSpecialistInfo, python::bases<CvInfoBase> >("CvSpecialistInfo")
		.def("getGreatPeopleUnitClass", &CvSpecialistInfo::getGreatPeopleUnitClass, "int ()")
		.def("getGreatPeopleRateChange", &CvSpecialistInfo::getGreatPeopleRateChange, "int ()")
		.def("getMissionType", &CvSpecialistInfo::getMissionType, "int ()")

		.def("isVisible", &CvSpecialistInfo::isVisible, "bool ()")
		
		.def("getYieldChange", &CvSpecialistInfo::getYieldChange, "int (int i)")
		.def("getCommerceChange", &CvSpecialistInfo::getCommerceChange, "int (int i)")
		.def("getExperience", &CvSpecialistInfo::getExperience, "int ()")
		.def("getFlavorValue", &CvSpecialistInfo::getFlavorValue, "int (int i)")

		.def("getTexture", &CvSpecialistInfo::getTexture, "string ()")
		;

	python::class_<CvTechInfo, python::bases<CvInfoBase> >("CvTechInfo")
		.def("getAdvisorType", &CvTechInfo::getAdvisorType, "int ()")
		.def("getAIWeight", &CvTechInfo::getAIWeight, "int ()")
		.def("getAITradeModifier", &CvTechInfo::getAITradeModifier, "int ()")
		.def("getResearchCost", &CvTechInfo::getResearchCost, "int ()")
		.def("getEra", &CvTechInfo::getEra, "int ()")
		.def("getTradeRoutes", &CvTechInfo::getTradeRoutes, "int ()")
		.def("getFeatureProductionModifier", &CvTechInfo::getFeatureProductionModifier, "int ()")
		.def("getWorkerSpeedModifier", &CvTechInfo::getWorkerSpeedModifier, "int ()")
		.def("getFirstFreeUnitClass", &CvTechInfo::getFirstFreeUnitClass, "int ()")
		//Kathy Barbarian from Tech Beginn
		.def("getFirstBarbarianUnitClass", &CvTechInfo::getFirstBarbarianUnitClass, "int ()")
		.def("isAttackDistantCity", &CvTechInfo::isAttackDistantCity, "bool ()")
		//Kathy Barbarian from Tech End
		.def("getHealth", &CvTechInfo::getHealth, "int ()")
		.def("getHappiness", &CvTechInfo::getHappiness, "int ()")
		.def("getFirstFreeTechs", &CvTechInfo::getFirstFreeTechs, "int ()")
		//Kathy Beginn Partisan Modifier
		.def("getPartisanModifier", &CvTechInfo::getPartisanModifier, "int ()")
		//Kathy End Partisan Modifier
		//Kathy Beginn VassalExtra Attitude
		.def("getVassalExtraAttitude", &CvTechInfo::getVassalExtraAttitude, "int ()")
		//Kathy End VassalExtra Attitude
		//Kathy Beginn Extra Attitude
		.def("getExtraAttitude", &CvTechInfo::getExtraAttitude, "int ()")
		//Kathy End ExtraAttitude
		//Kathy Beginn Einheitensuppor Tech
		.def("getFreeUnits", &CvTechInfo::getFreeUnits, "int ()")
		//Kathy End Einheitensuppor Tech
		//Kathy Beginn Inflation Modifier Tech
		.def("getInflationModifier", &CvTechInfo::getInflationModifier, "int ()")
		//Kathy End Inflation Modifier Tech
		//Kathy Beginn HurryAnger Modifier Tech
		.def("getHurryAngerModifier", &CvTechInfo::getHurryAngerModifier, "int ()")
		//Kathy End HurryAnger Modifier Tech
		//Kathy Beginn WarWeariness Modifier Tech
		.def("getWarWearinessModifier", &CvTechInfo::getWarWearinessModifier, "int ()")
		//Kathy End WarWeariness Modifier Tech
		//Kathy Beginn Religious Tolerance Tech
		.def("getReligiousTolerance", &CvTechInfo::getReligiousTolerance, "int ()")
		//Kathy End Religious Tolerance Tech
		//Kathy Beginn Defense Modifier Tech
		.def("getAllCityDefense", &CvTechInfo::getAllCityDefense, "int ()")
		//Kathy End Defense Modifier Tech
		//Kathy Beginn Archaeology Modifier Tech
		.def("getArchaeologyModifier", &CvTechInfo::getArchaeologyModifier, "int ()")
		//Kathy End Archaeology Modifier Tech
		//Kathy Beginn Tourism Modifier Tech
		.def("getTourismModifier", &CvTechInfo::getTourismModifier, "int ()")
		//Kathy End Tourism Modifier Tech
		.def("getAssetValue", &CvTechInfo::getAssetValue, "int ()")
		.def("getPowerValue", &CvTechInfo::getPowerValue, "int ()")
		
		//Kathy Columbian Exchange Tech Beginn
	//	.def("isColumbianExchange", &CvTechInfo::isColumbianExchange, "bool ()")
		//Kathy Columbian Exchange Tech End
		//Kathy Golden Age from Tech
		.def("isGoldenAge", &CvTechInfo::isGoldenAge, "bool ()")
		//Kathy Golden Age from Tech
		.def("getGridX", &CvTechInfo::getGridX, "int ()")
		.def("getGridY", &CvTechInfo::getGridY, "int ()")
		.def("isRepeat", &CvTechInfo::isRepeat, "bool ()")
		.def("isTrade", &CvTechInfo::isTrade, "bool ()")
		.def("isDisable", &CvTechInfo::isDisable, "bool ()")
		.def("isGoodyTech", &CvTechInfo::isGoodyTech, "bool ()")
		.def("isExtraWaterSeeFrom", &CvTechInfo::isExtraWaterSeeFrom, "bool ()")
		//Kathy Espionage Tech Beginn
		.def("isStealTech", &CvTechInfo::isStealTech, "bool ()")
		//Kathy Espionage Tech End
		//Kathy TechTransfer Tech Beginn
		.def("isTechTransfer", &CvTechInfo::isTechTransfer, "bool ()")
		//Kathy TechTransfer Tech End
		//Kathy TopSecret Tech Beginn
		.def("isTopSecret", &CvTechInfo::isTopSecret, "bool ()")
		//Kathy TopSecret Tech End
		//Kathy Kill Religion Tech Beginn
		.def("isKillOldReligion", &CvTechInfo::isKillOldReligion, "bool ()")
		//Kathy Kill Religion Tech End
		.def("isMapCentering", &CvTechInfo::isMapCentering, "bool ()")
		.def("isMapVisible", &CvTechInfo::isMapVisible, "bool ()")
		.def("isMapTrading", &CvTechInfo::isMapTrading, "bool ()")
		.def("isTechTrading", &CvTechInfo::isTechTrading, "bool ()")
		.def("isGoldTrading", &CvTechInfo::isGoldTrading, "bool ()")
		.def("isOpenBordersTrading", &CvTechInfo::isOpenBordersTrading, "bool ()")
		.def("isDefensivePactTrading", &CvTechInfo::isDefensivePactTrading, "bool ()")
		.def("isPermanentAllianceTrading", &CvTechInfo::isPermanentAllianceTrading, "bool ()")
		.def("isVassalStateTrading", &CvTechInfo::isVassalStateTrading, "bool ()")
		.def("isBridgeBuilding", &CvTechInfo::isBridgeBuilding, "bool ()")
		.def("isIrrigation", &CvTechInfo::isIrrigation, "bool ()")
		.def("isIgnoreIrrigation", &CvTechInfo::isIgnoreIrrigation, "bool ()")
		.def("isWaterWork", &CvTechInfo::isWaterWork, "bool ()")
		.def("isRiverTrade", &CvTechInfo::isRiverTrade, "bool ()")

		.def("getQuote", &CvTechInfo::getQuote, "wstring ()")
		.def("getSound", &CvTechInfo::getSound, "string ()")
		.def("getSoundMP", &CvTechInfo::getSoundMP, "string ()")

		.def("getDomainExtraMoves", &CvTechInfo::getDomainExtraMoves, "int (int i)")
		.def("getFlavorValue", &CvTechInfo::getFlavorValue, "int (int i)")
		.def("getPrereqOrTechs", &CvTechInfo::getPrereqOrTechs, "int (int i)")
		.def("getPrereqAndTechs", &CvTechInfo::getPrereqAndTechs, "int (int i)")

		.def("isCommerceFlexible", &CvTechInfo::isCommerceFlexible, "bool (int i)")
		.def("isTerrainTrade", &CvTechInfo::isTerrainTrade, "bool (int i)")
		;

	python::class_<CvPromotionInfo, python::bases<CvInfoBase> >("CvPromotionInfo")

		.def("getPrereqPromotion", &CvPromotionInfo::getPrereqPromotion, "int ()")
		.def("getPrereqOrPromotion1", &CvPromotionInfo::getPrereqOrPromotion1, "int ()")
		.def("getPrereqOrPromotion2", &CvPromotionInfo::getPrereqOrPromotion2, "int ()")
		.def("getActionInfoIndex", &CvPromotionInfo::getActionInfoIndex, "int ()")

		.def("getTechPrereq", &CvPromotionInfo::getTechPrereq, "int ()")
		.def("getStateReligionPrereq", &CvPromotionInfo::getStateReligionPrereq, "int ()")
		//Kathy Beginn Bonus Preq for Promotion/Equipment
		.def("getBonusType", &CvPromotionInfo::getBonusType, "int ()")
		//Kathy end Bonus Preq for Promotion/Equipment
		.def("getVisibilityChange", &CvPromotionInfo::getVisibilityChange, "int ()")
		.def("getMovesChange", &CvPromotionInfo::getMovesChange, "int ()")
		.def("getMoveDiscountChange", &CvPromotionInfo::getMoveDiscountChange, "int ()")
		.def("getAirRangeChange", &CvPromotionInfo::getAirRangeChange, "int ()")
		//Kathy beginn Paratrooper Promotion
		.def("getDropRangeChange", &CvPromotionInfo::getDropRangeChange, "int ()")
		//Kathy End Paratrooper Promotion
		.def("getInterceptChange", &CvPromotionInfo::getInterceptChange, "int ()")
		.def("getEvasionChange", &CvPromotionInfo::getEvasionChange, "int ()")
		.def("getWithdrawalChange", &CvPromotionInfo::getWithdrawalChange, "int ()")
		.def("getCargoChange", &CvPromotionInfo::getCargoChange, "int ()")
		.def("getCollateralDamageChange", &CvPromotionInfo::getCollateralDamageChange, "int ()")
		//Kathy beginn Area of Effect
		.def("getCollateralDamageMaxUnitsChange", &CvPromotionInfo::getCollateralDamageMaxUnitsChange, "int ()")
		//Kathy end Area of Effect
		.def("getBombardRateChange", &CvPromotionInfo::getBombardRateChange, "int ()")
		.def("getFirstStrikesChange", &CvPromotionInfo::getFirstStrikesChange, "int ()")
		.def("getChanceFirstStrikesChange", &CvPromotionInfo::getChanceFirstStrikesChange, "int ()")
		.def("getEnemyHealChange", &CvPromotionInfo::getEnemyHealChange, "int ()")
		.def("getNeutralHealChange", &CvPromotionInfo::getNeutralHealChange, "int ()")
		.def("getFriendlyHealChange", &CvPromotionInfo::getFriendlyHealChange, "int ()")
		.def("getSameTileHealChange", &CvPromotionInfo::getSameTileHealChange, "int ()")
		.def("getAdjacentTileHealChange", &CvPromotionInfo::getAdjacentTileHealChange, "int ()")
		.def("getCombatPercent", &CvPromotionInfo::getCombatPercent, "int ()")
		.def("getCityAttackPercent", &CvPromotionInfo::getCityAttackPercent, "int ()")
		.def("getCityDefensePercent", &CvPromotionInfo::getCityDefensePercent, "int ()")
		.def("getHillsAttackPercent", &CvPromotionInfo::getHillsAttackPercent, "int ()")
		.def("getHillsDefensePercent", &CvPromotionInfo::getHillsDefensePercent, "int ()")
		.def("getCommandType", &CvPromotionInfo::getCommandType, "int ()")
		.def("getRevoltProtection", &CvPromotionInfo::getRevoltProtection, "int ()")
		.def("getCollateralDamageProtection", &CvPromotionInfo::getCollateralDamageProtection, "int ()")
		.def("getPillageChange", &CvPromotionInfo::getPillageChange, "int ()")
		.def("getUpgradeDiscount", &CvPromotionInfo::getUpgradeDiscount, "int ()")
		//Kathy Beginn Workrate-Promotion		
		.def("getExtraWorkRate", &CvPromotionInfo::getExtraWorkRate, "int ()")
		//Kathy End Workrate-Promotion
		//Kathy Beginn EquipmentCost-Promotion		
		.def("getEquipmentCost", &CvPromotionInfo::getEquipmentCost, "int ()")
		//Kathy End EquipmentCost
		.def("getExperiencePercent", &CvPromotionInfo::getExperiencePercent, "int ()")
		.def("getKamikazePercent", &CvPromotionInfo::getKamikazePercent, "int ()")
		//Kathy Beginn Eifer
		.def("getReligiousBonus", &CvPromotionInfo::getReligiousBonus, "int ()")
		//Kathy End Eifer

		.def("isLeader", &CvPromotionInfo::isLeader, "bool ()")
		//Kathy beginn Slave Hunter
		.def("isSlaveHunter", &CvPromotionInfo::isSlaveHunter, "bool ()")
		//Kathy end Slave Hunter
		//Kathy beginn Formation
		.def("isFormation", &CvPromotionInfo::isFormation, "bool ()")
		//Kathy end Formation
		.def("isBlitz", &CvPromotionInfo::isBlitz, "bool ()")
		.def("isAmphib", &CvPromotionInfo::isAmphib, "bool ()")
		.def("isRiver", &CvPromotionInfo::isRiver, "bool ()")
		.def("isEnemyRoute", &CvPromotionInfo::isEnemyRoute, "bool ()")
		.def("isAlwaysHeal", &CvPromotionInfo::isAlwaysHeal, "bool ()")
		.def("isHillsDoubleMove", &CvPromotionInfo::isHillsDoubleMove, "bool ()")
		.def("isImmuneToFirstStrikes", &CvPromotionInfo::isImmuneToFirstStrikes, "bool ()")

		.def("getSound", &CvPromotionInfo::getSound, "string ()")

		// Arrays

		.def("getTerrainAttackPercent", &CvPromotionInfo::getTerrainAttackPercent, "int (int i)")
		.def("getTerrainDefensePercent", &CvPromotionInfo::getTerrainDefensePercent, "int (int i)")
		.def("getFeatureAttackPercent", &CvPromotionInfo::getFeatureAttackPercent, "int (int i)")
		.def("getFeatureDefensePercent", &CvPromotionInfo::getFeatureDefensePercent, "int (int i)")
		.def("getUnitCombatModifierPercent", &CvPromotionInfo::getUnitCombatModifierPercent, "int (int i)")
		.def("getDomainModifierPercent", &CvPromotionInfo::getDomainModifierPercent, "int (int i)")

		.def("getTerrainDoubleMove", &CvPromotionInfo::getTerrainDoubleMove, "bool (int i)")
		.def("getFeatureDoubleMove", &CvPromotionInfo::getFeatureDoubleMove, "bool (int i)")
		.def("getUnitCombat", &CvPromotionInfo::getUnitCombat, "bool (int i)")
		;

	python::class_<CvMissionInfo, python::bases<CvInfoBase> >("CvMissionInfo")
		.def("getTime", &CvMissionInfo::getTime, "int ()")

		.def("isSound", &CvMissionInfo::isSound, "bool ()")
		.def("isTarget", &CvMissionInfo::isTarget, "bool ()")
		.def("isBuild", &CvMissionInfo::isBuild, "bool ()")
		.def("getVisible", &CvMissionInfo::getVisible, "bool ()")

		.def("getWaypoint", &CvMissionInfo::getWaypoint, "string ()")
		;

	python::class_<CvActionInfo>("CvActionInfo")
		.def("getMissionData", &CvActionInfo::getMissionData, "int ()")
		.def("getCommandData", &CvActionInfo::getCommandData, "int ()")
		.def("getAutomateType", &CvActionInfo::getAutomateType, "int ()")

		.def("getInterfaceModeType", &CvActionInfo::getInterfaceModeType, "int ()")
		.def("getMissionType", &CvActionInfo::getMissionType, "int ()")
		.def("getCommandType", &CvActionInfo::getCommandType, "int ()")
		.def("getControlType", &CvActionInfo::getControlType, "int ()")

		.def("isConfirmCommand", &CvActionInfo::isConfirmCommand, "bool ()")
		.def("isVisible", &CvActionInfo::isVisible, "bool ()")

		.def("getHotKey", &CvActionInfo::getHotKey, "string ()")
		.def("getButton", &CvActionInfo::getButton, "string ()")
		;

	python::class_<CvUnitInfo, python::bases<CvInfoBase, CvScalableInfo> >("CvUnitInfo")

		.def("getAIWeight", &CvUnitInfo::getAIWeight, "int ()")
		.def("getProductionCost", &CvUnitInfo::getProductionCost, "int ()")
		.def("getHurryCostModifier", &CvUnitInfo::getHurryCostModifier, "int ()")
		.def("getMinAreaSize", &CvUnitInfo::getMinAreaSize, "int ()")
		.def("getMoves", &CvUnitInfo::getMoves, "int ()")
		.def("getAirRange", &CvUnitInfo::getAirRange, "int ()")
		.def("getAirUnitCap", &CvUnitInfo::getAirUnitCap, "int ()")
		.def("getDropRange", &CvUnitInfo::getDropRange, "int ()")
		.def("getNukeRange", &CvUnitInfo::getNukeRange, "int ()")
		.def("getWorkRate", &CvUnitInfo::getWorkRate, "int ()")
		.def("getBaseDiscover", &CvUnitInfo::getBaseDiscover, "int ()")
		.def("getDiscoverMultiplier", &CvUnitInfo::getDiscoverMultiplier, "int ()")
		.def("getBaseHurry", &CvUnitInfo::getBaseHurry, "int ()")
		.def("getHurryMultiplier", &CvUnitInfo::getHurryMultiplier, "int ()")
		.def("getBaseTrade", &CvUnitInfo::getBaseTrade, "int ()")
		.def("getTradeMultiplier", &CvUnitInfo::getTradeMultiplier, "int ()")
		.def("getGreatWorkCulture", &CvUnitInfo::getGreatWorkCulture, "int ()")
		.def("getEspionagePoints", &CvUnitInfo::getEspionagePoints, "int ()")
		//Kathy Beginn Gold Beute
		.def("getGoldLoot", &CvUnitInfo::getGoldLoot, "int ()")
		//Kathy End Gold Beute
		//Kathy Beginn City State Missions
		.def("getCityStateMissionType", &CvUnitInfo::getCityStateMissionType, "int ()")
		//Kathy EndCity State Missions
		.def("getCombat", &CvUnitInfo::getCombat, "int ()")
		.def("setCombat", &CvUnitInfo::setCombat, "void (int)")
		.def("getCombatLimit", &CvUnitInfo::getCombatLimit, "int ()")
		.def("getAirCombat", &CvUnitInfo::getAirCombat, "int ()")
		.def("getAirCombatLimit", &CvUnitInfo::getAirCombatLimit, "int ()")
		.def("getXPValueAttack", &CvUnitInfo::getXPValueAttack, "int ()")
		.def("getXPValueDefense", &CvUnitInfo::getXPValueDefense, "int ()")
		.def("getFirstStrikes", &CvUnitInfo::getFirstStrikes, "int ()")
		.def("getChanceFirstStrikes", &CvUnitInfo::getChanceFirstStrikes, "int ()")
		.def("getInterceptionProbability", &CvUnitInfo::getInterceptionProbability, "int ()")
		.def("getEvasionProbability", &CvUnitInfo::getEvasionProbability, "int ()")
		.def("getWithdrawalProbability", &CvUnitInfo::getWithdrawalProbability, "int ()")
		.def("getCollateralDamage", &CvUnitInfo::getCollateralDamage, "int ()")
		.def("getCollateralDamageLimit", &CvUnitInfo::getCollateralDamageLimit, "int ()")
		.def("getCollateralDamageMaxUnits", &CvUnitInfo::getCollateralDamageMaxUnits, "int ()")
		.def("getCityAttackModifier", &CvUnitInfo::getCityAttackModifier, "int ()")
		.def("getCityDefenseModifier", &CvUnitInfo::getCityDefenseModifier, "int ()")
		.def("getAnimalCombatModifier", &CvUnitInfo::getAnimalCombatModifier, "int ()")
		.def("getHillsAttackModifier", &CvUnitInfo::getHillsAttackModifier, "int ()")
		.def("getHillsDefenseModifier", &CvUnitInfo::getHillsDefenseModifier, "int ()")
		.def("getBombRate", &CvUnitInfo::getBombRate, "int ()")
		.def("getBombardRate", &CvUnitInfo::getBombardRate, "int ()")
		.def("getSpecialCargo", &CvUnitInfo::getSpecialCargo, "int ()")
		.def("getDomainCargo", &CvUnitInfo::getDomainCargo, "int ()")

		.def("getCargoSpace", &CvUnitInfo::getCargoSpace, "int ()")
		.def("getConscriptionValue", &CvUnitInfo::getConscriptionValue, "int ()")
		.def("getCultureGarrisonValue", &CvUnitInfo::getCultureGarrisonValue, "int ()")
		.def("getExtraCost", &CvUnitInfo::getExtraCost, "int ()")
		.def("getAssetValue", &CvUnitInfo::getAssetValue, "int ()")
		.def("getPowerValue", &CvUnitInfo::getPowerValue, "int ()")
		.def("getUnitClassType", &CvUnitInfo::getUnitClassType, "int ()")
		.def("getSpecialUnitType", &CvUnitInfo::getSpecialUnitType, "int ()")
		.def("getUnitCaptureClassType", &CvUnitInfo::getUnitCaptureClassType, "int ()")
		//Kathy Beginn Bonus Left
		.def("getBonusLeftType", &CvUnitInfo::getBonusLeftType, "int ()")
		//Kathy Beginn Bonus Left
		.def("getUnitCombatType", &CvUnitInfo::getUnitCombatType, "int ()")
		.def("getDomainType", &CvUnitInfo::getDomainType, "int ()")
		.def("getDefaultUnitAIType", &CvUnitInfo::getDefaultUnitAIType, "int ()")
		.def("getInvisibleType", &CvUnitInfo::getInvisibleType, "int ()")
		.def("getNumSeeInvisibleTypes", &CvUnitInfo::getNumSeeInvisibleTypes, "int ()")
		.def("getSeeInvisibleType", &CvUnitInfo::getSeeInvisibleType, "int (int)")
		.def("getAdvisorType", &CvUnitInfo::getAdvisorType, "int ()")
		.def("getHolyCity", &CvUnitInfo::getHolyCity, "int ()")
		.def("getReligionType", &CvUnitInfo::getReligionType, "int ()")
		.def("getStateReligion", &CvUnitInfo::getStateReligion, "int ()")
		.def("getPrereqReligion", &CvUnitInfo::getPrereqReligion, "int ()")
		.def("getPrereqCorporation", &CvUnitInfo::getPrereqCorporation, "int ()")
		.def("getPrereqBuilding", &CvUnitInfo::getPrereqBuilding, "int ()")
		.def("getPrereqAndTech", &CvUnitInfo::getPrereqAndTech, "int ()")
		.def("getPrereqAndBonus", &CvUnitInfo::getPrereqAndBonus, "int ()")
		.def("getGroupSize", &CvUnitInfo::getGroupSize, "int ()")
		.def("getGroupDefinitions", &CvUnitInfo::getGroupDefinitions, "int ()")
		.def("getMeleeWaveSize", &CvUnitInfo::getMeleeWaveSize, "int ()")
		.def("getRangedWaveSize", &CvUnitInfo::getRangedWaveSize, "int ()")
		.def("getNumUnitNames", &CvUnitInfo::getNumUnitNames, "int ()")
		.def("getCommandType", &CvUnitInfo::getCommandType, "int ()")

		.def("isAnimal", &CvUnitInfo::isAnimal, "bool ()")
		//Kathy Beginn Railroad Restriction
		.def("isRailsOnly", &CvUnitInfo::isRailsOnly, "bool ()")
		//Kathy End Railroad Restriction
		//Kathy Beginn Carrier Restriction
		.def("isNoHelicopterAttackFrom", &CvUnitInfo::isNoHelicopterAttackFrom, "bool ()")
		//Kathy End Carrier Restriction
		//Kathy Beginn Require Military Citystate
		.def("isRequireMilitaryCitystate", &CvUnitInfo::isRequireMilitaryCitystate, "bool ()")
		//Kathy End Require Military Citystate
		//Kathy Beginn Require Maritime Citystate
		.def("isRequireMaritimeCitystate", &CvUnitInfo::isRequireMaritimeCitystate, "bool ()")
		//Kathy End Require Maritime Citystate
		.def("isFoodProduction", &CvUnitInfo::isFoodProduction, "bool ()")
		.def("isNoBadGoodies", &CvUnitInfo::isNoBadGoodies, "bool ()")
/************************************************************************************************/
/* UNOFFICIAL_PATCH                       03/20/10                       Afforess & jdog5000    */
/*                                                                                              */
/* Bugfix                                                                                       */
/************************************************************************************************/
		.def("isOnlyDefensive", &CvUnitInfo::isOnlyDefensive, "bool ()")
/************************************************************************************************/
/* UNOFFICIAL_PATCH                        END                                                  */
/************************************************************************************************/
		.def("isNoCapture", &CvUnitInfo::isNoCapture, "bool ()")
		.def("isRivalTerritory", &CvUnitInfo::isRivalTerritory, "bool ()")
		.def("isMilitaryHappiness", &CvUnitInfo::isMilitaryHappiness, "bool ()")
		.def("isMilitarySupport", &CvUnitInfo::isMilitarySupport, "bool ()")
		.def("isMilitaryProduction", &CvUnitInfo::isMilitaryProduction, "bool ()")
		.def("isPillage", &CvUnitInfo::isPillage, "bool ()")
		.def("isSpy", &CvUnitInfo::isSpy, "bool ()")
		.def("isSabotage", &CvUnitInfo::isSabotage, "bool ()")
		.def("isDestroy", &CvUnitInfo::isDestroy, "bool ()")
		.def("isStealPlans", &CvUnitInfo::isStealPlans, "bool ()")
		.def("isInvestigate", &CvUnitInfo::isInvestigate, "bool ()")
		.def("isCounterSpy", &CvUnitInfo::isCounterSpy, "bool ()")
		.def("isFound", &CvUnitInfo::isFound, "bool ()")
		.def("isGoldenAge", &CvUnitInfo::isGoldenAge, "bool ()")
		.def("isInvisible", &CvUnitInfo::isInvisible, "bool ()")
		.def("setInvisible", &CvUnitInfo::setInvisible, "void (bool bEnable)")
		.def("isFirstStrikeImmune", &CvUnitInfo::isFirstStrikeImmune, "bool ()")
		.def("isNoDefensiveBonus", &CvUnitInfo::isNoDefensiveBonus, "bool ()")
		.def("isIgnoreBuildingDefense", &CvUnitInfo::isIgnoreBuildingDefense, "bool ()")
		.def("isCanMoveImpassable", &CvUnitInfo::isCanMoveImpassable, "bool ()")
		.def("isCanMoveAllTerrain", &CvUnitInfo::isCanMoveAllTerrain, "bool ()")
		.def("isFlatMovementCost", &CvUnitInfo::isFlatMovementCost, "bool ()")
		.def("isIgnoreTerrainCost", &CvUnitInfo::isIgnoreTerrainCost, "bool ()")
		.def("isNukeImmune", &CvUnitInfo::isNukeImmune, "bool ()")
		.def("isPrereqBonuses", &CvUnitInfo::isPrereqBonuses, "bool ()")
		.def("isPrereqReligion", &CvUnitInfo::isPrereqReligion, "bool ()")
		.def("isMechUnit", &CvUnitInfo::isMechUnit, "bool ()")
		.def("isRenderBelowWater", &CvUnitInfo::isRenderBelowWater, "bool ()")
		.def("isSuicide", &CvUnitInfo::isSuicide, "bool ()")
		.def("isLineOfSight", &CvUnitInfo::isLineOfSight, "bool ()")
		.def("isHiddenNationality", &CvUnitInfo::isHiddenNationality, "bool ()")
		.def("isAlwaysHostile", &CvUnitInfo::isAlwaysHostile, "bool ()")

		.def("getUnitMaxSpeed", &CvUnitInfo::getUnitMaxSpeed, "float ()")
		.def("getUnitPadTime", &CvUnitInfo::getUnitPadTime, "float ()")

		// Arrays

		.def("getPrereqAndTechs", &CvUnitInfo::getPrereqAndTechs, "int (int i)")
		.def("getPrereqOrBonuses", &CvUnitInfo::getPrereqOrBonuses, "int (int i)")
		.def("getProductionTraits", &CvUnitInfo::getProductionTraits, "int (int i)")
		.def("getFlavorValue", &CvUnitInfo::getFlavorValue, "int (int i)")
		.def("getTerrainAttackModifier", &CvUnitInfo::getTerrainAttackModifier, "int (int i)")
		.def("getTerrainDefenseModifier", &CvUnitInfo::getTerrainDefenseModifier, "int (int i)")
		.def("getFeatureAttackModifier", &CvUnitInfo::getFeatureAttackModifier, "int (int i)")
		.def("getFeatureDefenseModifier", &CvUnitInfo::getFeatureDefenseModifier, "int (int i)")
		.def("getUnitClassAttackModifier", &CvUnitInfo::getUnitClassAttackModifier, "int (int i)")
		.def("getUnitClassDefenseModifier", &CvUnitInfo::getUnitClassDefenseModifier, "int (int i)")
		.def("getUnitCombatModifier", &CvUnitInfo::getUnitCombatModifier, "int (int i)")
		.def("getDomainModifier", &CvUnitInfo::getDomainModifier, "int (int i)")
		.def("getBonusProductionModifier", &CvUnitInfo::getBonusProductionModifier, "int (int i)")
		.def("getUnitGroupRequired", &CvUnitInfo::getUnitGroupRequired, "int (int i)")

		.def("getUpgradeUnitClass", &CvUnitInfo::getUpgradeUnitClass, "bool (int i)")
		.def("getTargetUnitClass", &CvUnitInfo::getTargetUnitClass, "bool (int i)")
		.def("getTargetUnitCombat", &CvUnitInfo::getTargetUnitCombat, "bool (int i)")
		.def("getDefenderUnitClass", &CvUnitInfo::getDefenderUnitClass, "bool (int i)")
		.def("getDefenderUnitCombat", &CvUnitInfo::getDefenderUnitCombat, "bool (int i)")
		.def("getUnitAIType", &CvUnitInfo::getUnitAIType, "bool (int i)")
		.def("getNotUnitAIType", &CvUnitInfo::getNotUnitAIType, "bool (int i)")
		.def("getBuilds", &CvUnitInfo::getBuilds, "bool (int i)")
		.def("getReligionSpreads", &CvUnitInfo::getReligionSpreads, "int (int i)")
		.def("getCorporationSpreads", &CvUnitInfo::getCorporationSpreads, "int (int i)")
		.def("getTerrainPassableTech", &CvUnitInfo::getTerrainPassableTech, "int (int i)")
		.def("getFeaturePassableTech", &CvUnitInfo::getFeaturePassableTech, "int (int i)")
		.def("getFlankingStrikeUnitClass", &CvUnitInfo::getFlankingStrikeUnitClass, "int (int i)")
		.def("getGreatPeoples", &CvUnitInfo::getGreatPeoples, "bool (int i)")
		.def("getBuildings", &CvUnitInfo::getBuildings, "bool (int i)")
		.def("getForceBuildings", &CvUnitInfo::getForceBuildings, "bool (int i)")
		.def("getTerrainImpassable", &CvUnitInfo::getTerrainImpassable, "bool (int i)")
		.def("getFeatureImpassable", &CvUnitInfo::getFeatureImpassable, "bool (int i)")
		.def("getTerrainNative", &CvUnitInfo::getTerrainNative, "bool (int i)")
		.def("getFeatureNative", &CvUnitInfo::getFeatureNative, "bool (int i)")
		.def("getFreePromotions", &CvUnitInfo::getFreePromotions, "bool (int i)")
		.def("getLeaderPromotion", &CvUnitInfo::getLeaderPromotion, "int ()")
		.def("getLeaderExperience", &CvUnitInfo::getLeaderExperience, "int ()")

		.def("getEarlyArtDefineTag", &CvUnitInfo::getEarlyArtDefineTag, "string (int i, UnitArtStyleTypes eStyle)")
		.def("getLateArtDefineTag", &CvUnitInfo::getLateArtDefineTag, "string (int i, UnitArtStyleTypes eStyle)")
		.def("getMiddleArtDefineTag", &CvUnitInfo::getMiddleArtDefineTag, "string (int i, UnitArtStyleTypes eStyle)")
		.def("getUnitNames", &CvUnitInfo::getUnitNames, "string (int i)")
		.def("getArtInfo", &CvUnitInfo::getArtInfo,  python::return_value_policy<python::reference_existing_object>(), "CvArtInfoUnit* (int i, bool bLate)")
		;

	python::class_<CvSpecialUnitInfo, python::bases<CvInfoBase> >("CvSpecialUnitInfo")
		.def("isValid", &CvSpecialUnitInfo::isValid, "bool ()")
		.def("isCityLoad", &CvSpecialUnitInfo::isCityLoad, "bool ()")

		.def("isCarrierUnitAIType", &CvSpecialUnitInfo::isCarrierUnitAIType, "bool (int i)")
		.def("getProductionTraits", &CvSpecialUnitInfo::getProductionTraits, "int (int i)")
		;

	python::class_<CvCivicOptionInfo, python::bases<CvInfoBase> >("CvCivicOptionInfo")
		.def("getTraitNoUpkeep", &CvCivicOptionInfo::getTraitNoUpkeep, "bool (int i)")
		;

	python::class_<CvCivicInfo, python::bases<CvInfoBase> >("CvCivicInfo")

		.def("getCivicOptionType", &CvCivicInfo::getCivicOptionType, "int ()")
		.def("getAnarchyLength", &CvCivicInfo::getAnarchyLength, "int ()")
		.def("getUpkeep", &CvCivicInfo::getUpkeep, "int ()")
		.def("getAIWeight", &CvCivicInfo::getAIWeight, "int ()")
		.def("getGreatPeopleRateModifier", &CvCivicInfo::getGreatPeopleRateModifier, "int ()")
		.def("getGreatGeneralRateModifier", &CvCivicInfo::getGreatGeneralRateModifier, "int ()")
		.def("getDomesticGreatGeneralRateModifier", &CvCivicInfo::getDomesticGreatGeneralRateModifier, "int ()")
		.def("getStateReligionGreatPeopleRateModifier", &CvCivicInfo::getStateReligionGreatPeopleRateModifier, "int ()")
		.def("getDistanceMaintenanceModifier", &CvCivicInfo::getDistanceMaintenanceModifier, "int ()")
		.def("getNumCitiesMaintenanceModifier", &CvCivicInfo::getNumCitiesMaintenanceModifier, "int ()")
		.def("getCorporationMaintenanceModifier", &CvCivicInfo::getCorporationMaintenanceModifier, "int ()")
		.def("getExtraHealth", &CvCivicInfo::getExtraHealth, "int ()")
		.def("getFreeExperience", &CvCivicInfo::getFreeExperience, "int ()")
		.def("getWorkerSpeedModifier", &CvCivicInfo::getWorkerSpeedModifier, "int ()")
		.def("getImprovementUpgradeRateModifier", &CvCivicInfo::getImprovementUpgradeRateModifier, "int ()")
		//Kathy beginn Tourism
		.def("getTourismModifier", &CvCivicInfo::getTourismModifier, "int ()")
		//Kathy End Tourism
		//Kathy beginn Free Population
		.def("getFreePopulation", &CvCivicInfo::getFreePopulation, "int ()")
		//Kathy End Free Population
		//Kathy beginn Golden Age Modifier
		.def("getGoldenAgeModifier", &CvCivicInfo::getGoldenAgeModifier, "int ()")
		//Kathy End Golden Age Modifier
		.def("getMilitaryProductionModifier", &CvCivicInfo::getMilitaryProductionModifier, "int ()")
		.def("getBaseFreeUnits", &CvCivicInfo::getBaseFreeUnits, "int ()")
		.def("getBaseFreeMilitaryUnits", &CvCivicInfo::getBaseFreeMilitaryUnits, "int ()")
		.def("getFreeUnitsPopulationPercent", &CvCivicInfo::getFreeUnitsPopulationPercent, "int ()")
		.def("getFreeMilitaryUnitsPopulationPercent", &CvCivicInfo::getFreeMilitaryUnitsPopulationPercent, "int ()")
		.def("getGoldPerUnit", &CvCivicInfo::getGoldPerUnit, "int ()")
		.def("getGoldPerMilitaryUnit", &CvCivicInfo::getGoldPerMilitaryUnit, "int ()")
		.def("getHappyPerMilitaryUnit", &CvCivicInfo::getHappyPerMilitaryUnit, "int ()")
		.def("getLargestCityHappiness", &CvCivicInfo::getLargestCityHappiness, "int ()")
		.def("getWarWearinessModifier", &CvCivicInfo::getWarWearinessModifier, "int ()")
		.def("getFreeSpecialist", &CvCivicInfo::getFreeSpecialist, "int ()")
		.def("getTradeRoutes", &CvCivicInfo::getTradeRoutes, "int ()")
		.def("getTechPrereq", &CvCivicInfo::getTechPrereq, "int ()")
		.def("getCivicPercentAnger", &CvCivicInfo::getCivicPercentAnger, "int ()")
		.def("getMaxConscript", &CvCivicInfo::getMaxConscript, "int ()")
		//Kathy Beginn GlobalHousing Modifier
		.def("getGlobalHousing", &CvCivicInfo::getGlobalHousing, "int ()")
		//Kathy Beginn GlobalHousing Modifier
		//Kathy Beginn Feature Production Modifier
		.def("getFeatureProductionModifier", &CvCivicInfo::getFeatureProductionModifier, "int ()")
		//Kathy Beginn AttitudebonusCitystate Modifier
		.def("getAttitudebonusCitystate", &CvCivicInfo::getAttitudebonusCitystate, "int ()")
		//Kathy Beginn Vote Modifier
		.def("getVoteModifier", &CvCivicInfo::getVoteModifier, "int ()")
		//Kathy End Vote Modifier
		//Kathy Beginn Max NationalWonderModifier
		.def("getMaxNationalWonderModifier", &CvCivicInfo::getMaxNationalWonderModifier, "int ()")
		//Kathy End Max NationalWonderModifier
		//Kathy Beginn Enemy KU Modifier
		.def("getEnemyWarWearinessModifier", &CvCivicInfo::getEnemyWarWearinessModifier, "int ()")
		//Kathy End Enemy KU Modifier
		//Kathy Beginn Partisan Modifier
		.def("getPartisanModifier", &CvCivicInfo::getPartisanModifier, "int ()")
		//Kathy End Partisan Modifier
		//Kathy Beginn ReligiousTolerance
		.def("getReligiousTolerance", &CvCivicInfo::getReligiousTolerance, "int ()")
		//Kathy End ReligiousTolerance
		//Kathy Beginn City Defense Civic
		.def("getAllCityDefense", &CvCivicInfo::getAllCityDefense, "int ()")
		//Kathy End City Defense Civic
		.def("getStateReligionHappiness", &CvCivicInfo::getStateReligionHappiness, "int ()")
		.def("getNonStateReligionHappiness", &CvCivicInfo::getNonStateReligionHappiness, "int ()")
		.def("getStateReligionUnitProductionModifier", &CvCivicInfo::getStateReligionUnitProductionModifier, "int ()")
		.def("getStateReligionBuildingProductionModifier", &CvCivicInfo::getStateReligionBuildingProductionModifier, "int ()")
		.def("getStateReligionFreeExperience", &CvCivicInfo::getStateReligionFreeExperience, "int ()")
		.def("getExpInBorderModifier", &CvCivicInfo::getExpInBorderModifier, "bool ()")

		.def("isMilitaryFoodProduction", &CvCivicInfo::isMilitaryFoodProduction, "bool ()")
		//Kathy beginn Erbrecht Civic
		.def("isErbrechtCivic", &CvCivicInfo::isErbrechtCivic, "bool ()")
		.def("isRequireErbrechtCivic", &CvCivicInfo::isRequireErbrechtCivic, "bool ()")
		//Kathy end Erbrecht Civics
		//Kathy beginn Election Civic
		.def("isElectionCivic", &CvCivicInfo::isElectionCivic, "bool ()")
		.def("isRequireElectionCivic", &CvCivicInfo::isRequireElectionCivic, "bool ()")
		//Kathy end Election Civics
		//Kathy beginn Wahlbetrug
		.def("isChoseParty", &CvCivicInfo::isChoseParty, "bool ()")
		//Kathy end Wahlbetrug
		//Kathy beginn Ideology Civic
		.def("isIdeologyCivic", &CvCivicInfo::isIdeologyCivic, "bool ()")
		.def("isRequireIdeologyCivic", &CvCivicInfo::isRequireIdeologyCivic, "bool ()")
		//Kathy end Ideology Civics
		//Kathy beginn Tenet Civic
		.def("isTenetCivic", &CvCivicInfo::isTenetCivic, "bool ()")
		.def("isRequireTenetCivic", &CvCivicInfo::isRequireTenetCivic, "bool ()")
		//Kathy end Tenet Civics
		//Kathy beginn Random Election Civic
		.def("isRandomElectionCivic", &CvCivicInfo::isRandomElectionCivic, "bool ()")
		//Kathy end Random Election Civics
		//Kathy beginn Offshore Finance Civic
		.def("isOffshoreFinance", &CvCivicInfo::isOffshoreFinance, "bool ()")
		//Kathy end Offshore Finance Civic
		//Kathy beginn Military Citystates
		.def("isAllowCitystateUnits", &CvCivicInfo::isAllowCitystateUnits, "bool ()")
		//Kathy end Military Citystates
		.def("isNoUnhealthyPopulation", &CvCivicInfo::isNoUnhealthyPopulation, "bool ()")
		.def("isBuildingOnlyHealthy", &CvCivicInfo::isBuildingOnlyHealthy, "bool ()")
		.def("isNoForeignTrade", &CvCivicInfo::isNoForeignTrade, "bool ()")
		.def("isNoCorporations", &CvCivicInfo::isNoCorporations, "bool ()")
		.def("isNoForeignCorporations", &CvCivicInfo::isNoForeignCorporations, "bool ()")
		.def("isStateReligion", &CvCivicInfo::isStateReligion, "bool ()")
		.def("isNoNonStateReligionSpread", &CvCivicInfo::isNoNonStateReligionSpread, "bool ()")

		.def("pyGetWeLoveTheKing", &CvCivicInfo::pyGetWeLoveTheKing, "wstring ()")

		// Arrays

		.def("getYieldModifier", &CvCivicInfo::getYieldModifier, "int (int i)")
		.def("getCapitalYieldModifier", &CvCivicInfo::getCapitalYieldModifier, "int (int i)")
		.def("getTradeYieldModifier", &CvCivicInfo::getTradeYieldModifier, "int (int i)")
		.def("getCommerceModifier", &CvCivicInfo::getCommerceModifier, "int (int i)")
		.def("getCapitalCommerceModifier", &CvCivicInfo::getCapitalCommerceModifier, "int (int i)")
		//Kathy beginn Religious Commcerce from Civis
		.def("getStateReligionCommerce", &CvCivicInfo::getStateReligionCommerce, "int (int i)")
		//Kathy end Religious Commcerce from Civis
		.def("getSpecialistExtraCommerce", &CvCivicInfo::getSpecialistExtraCommerce, "int (int i)")
		.def("getBuildingHappinessChanges", &CvCivicInfo::getBuildingHappinessChanges, "int (int i)")
		.def("getBuildingHealthChanges", &CvCivicInfo::getBuildingHealthChanges, "int (int i)")
		.def("getFeatureHappinessChanges", &CvCivicInfo::getFeatureHappinessChanges, "int (int i)")

		.def("isHurry", &CvCivicInfo::isHurry, "bool (int i)")
		.def("isSpecialBuildingNotRequired", &CvCivicInfo::isSpecialBuildingNotRequired, "bool (int i)")
		.def("isSpecialistValid", &CvCivicInfo::isSpecialistValid, "bool (int i)")

		.def("getImprovementYieldChanges", &CvCivicInfo::getImprovementYieldChanges, "int (int i, int j)")
		;

	python::class_<CvUnitClassInfo, python::bases<CvInfoBase> >("CvUnitClassInfo")
		.def("getMaxGlobalInstances", &CvUnitClassInfo::getMaxGlobalInstances, "int ()")
		.def("getMaxTeamInstances", &CvUnitClassInfo::getMaxTeamInstances, "int ()")
		.def("getMaxPlayerInstances", &CvUnitClassInfo::getMaxPlayerInstances, "int ()")
		.def("getInstanceCostModifier", &CvUnitClassInfo::getInstanceCostModifier, "int ()")
		.def("getDefaultUnitIndex", &CvUnitClassInfo::getDefaultUnitIndex, "int ()")
		;


}
